#include <lpc21XX.h>
#include <stdio.h>
#define U1ACR          (*((volatile unsigned char *) 0xE0010020))      // Definition for the "new" register in the /01 Revision
                                                                       // please, comment out the above line, if it's already defined in the lpc21xx.h file
#include "uart.h"													   // Include support for a Serial Console
#define  console  0													   // 0 = UART0 , 1 = UART1



int main (void) {

  int rev = -1;
  int i   =  0;

  // P0.4 will be used for a led as an Activity Indicator (optional)
  IODIR0 = 0x00000010;
  IOCLR0 = 0x00000010;

  // Setting up the serial console
  UARTInit(console);
  sendstr (console, "\r\n===========================================================================\r\n");
  sendstr (console, "Part Revision /01 Detector: (for LPC21xx/22xx and LPC2104/5/6 devices)\r\n\n"); 
  sendstr (console, "This device is ");

  // Revision Detection Test... 
  while(1)
  {

    // Write '1' test
    U1ACR |= 0x00000002; 
    if (!(U1ACR & 0x00000002))				 // if it's a '0', the test fails
    {
      rev = 0;
      sendstr (console, "an old part (no /01 Revision)\r\n"); 
	  break;
    }
    // Write '0' test
    U1ACR &= 0xFFFFFFFD;  //~0x00000002; 
    if(U1ACR & 0x00000002)					 // if it's a '1', the test fails
    {
      rev = 0;
      sendstr (console, "an old part (no /01 Revision)\r\n"); 
	  break;
    }
    rev = 1;
    sendstr (console, "a /01 Revision! (or greater)\r\n"); 
    break;
  }

  // Board Activity Led implementation...  
  while(1)
  {
    for(i=0;i<1000000;i++) {  
    }  
    IOSET0 = 0x00000010;
    for(i=0;i<1000000;i++) {
    }  
    IOCLR0 = 0x00000010;
  }
}
